//-------------------------------------------------------------------------------------
// SID Monitor - Utility for Sudden Ionospheric Disturbances Monitoring Stations
// Copyright (C) 2006 - Lionel Loudet
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//-------------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using WeifenLuo.WinFormsUI;

namespace SID_monitor
{
    public partial class OutputTextBoxDockablePanel : DockContent
    {
        // AddOuputText... methods signature
        public delegate void AddOutputTextDelegate(string text);

        // declaration of the public methods
        public AddOutputTextDelegate AddOutputTextMessage;
        public AddOutputTextDelegate AddOutputTextMessageWithoutDate; 
        public AddOutputTextDelegate AddOutputTextWarningMessage;
        public AddOutputTextDelegate AddOutputTextErrorMessage;
        public AddOutputTextDelegate AddOutputTextRRDToolMessage;
        public AddOutputTextDelegate AddOutputTextRRDToolErrorMessage;
       


        public OutputTextBoxDockablePanel()
        {
            InitializeComponent();

            // definition of the public methods
            AddOutputTextMessage = this.outputTextBox.AddOutputTextMessage;
            AddOutputTextMessageWithoutDate = this.outputTextBox.AddOutputTextMessageWithoutDate; 
            AddOutputTextWarningMessage = this.outputTextBox.AddOutputTextWarningMessage;
            AddOutputTextErrorMessage = this.outputTextBox.AddOutputTextErrorMessage;
            AddOutputTextRRDToolMessage = this.outputTextBox.AddOutputTextRRDToolMessage;
            AddOutputTextRRDToolErrorMessage = this.outputTextBox.AddOutputTextRRDToolErrorMessage;


        }

        #region Properties
        public OutputTextBox OutputTextBox
        {
            get
            {
                return this.outputTextBox;
            }
        }
        #endregion


    }
}
